
dslversion 1.0.0

namespace com.ge.mpiu
version 1.1.0
displayname "PTP Parameters"

using com.ge.csp.VLAN; 1.1.0
using com.ge.csp.Profile; 1.1.0
using com.ge.csp.Ethernet; 1.1.0
using com.ge.csp.OperationMode; 1.1.0
using com.ge.csp.DelayMechanism; 1.1.0

entity PTP {
  mandatory profile as Profile default Utility_IEC_61850_9_3 "GMC Protocol Profile";
  mandatory domainNumber as int32 default 0 <MIN 0, MAX 255, STEP 1> "A domain consists of one or more PTP devices communicating with each other as defined by the protocol. A domain shall define the scope of PTP message communication, state, operations, data sets, and timescale.";
  mandatory readonly networkProtocol as Ethernet default Ethernet_Layer_2 "The identification of the transport protocol in use for a communication path";
  mandatory vlan as VLAN;
  mandatory readonly operationMode as OperationMode default OC "The type of clock IED is";
  mandatory readonly delayMechanism as DelayMechanism default P2P "indicate the propagation delay measuring option used by the port in computing <meanPathDelay>";
  mandatory grandMasterPriority1 as int32 default 255 <MIN 0, MAX 255, STEP 1> "The attribute priority1 is used in the execution of the best master clock algorithm; Lower values take precedence.";
  mandatory grandMasterPriority2 as int32 default 255 <MIN 0, MAX 255, STEP 1> "The attribute priority2 is used in the execution of the best master clock algorithm; Lower values take precedence.";
  mandatory announceReceiptTimeout as int32 default 3 <MIN 3, MAX 255, STEP 1, UNIT "s"> "shall specify the number of announceInterval that has to pass without receipt of an Announce message before the occurrence of the event ANNOUNCE_RECEIPT_TIMEOUT_EXPIRES";
}
