
dslversion 1.0.0

namespace com.ge.mpiu
version 1.2.4
displayname "Sampled Value Simulation"

using com.ge.mpiu.DefaultSmpSynch; 1.1.0
using com.ge.mpiu.Enum_BayName ; 1.1.0
using com.ge.mpiu.GenericHealth_MPS ; 1.2.4
using com.ge.mpiu.currenttransformersimulation.CurrentTransformerSimulation; 1.1.0
using com.ge.mpiu.voltagetransformersimulation.VoltageTransformerSimulation; 1.1.0

entity SampledValueSimulation {
  mandatory smpSynchStatic as bool default true "For simulated SV this indicates whether the user wants to use static sample sync value or the one corresponding to the current IED sync status.",
  mandatory defaultSmpSynch as DefaultSmpSynch default GLOBAL "For simulated SV, when smpSynchStatic is true, then this value represent the value send at the smpsynch field on the SV Frame";
  mandatory defaultGmIdentity as string default "00:50:C2:FF:FE:F4:7B:88" <STRLEN 23, REGEX '^((([0-9]|[A-F]|[a-f]){2})(:(([0-9]|[A-F]|[a-f]){2})){7})$'> "For simulated SV, when smpSynchStatic is true, then this value represent the value send at the SynchSrcID field on the SV Frame";
  mandatory currenttransformersimulation as CurrentTransformerSimulation;
  mandatory voltagetransformersimulation as VoltageTransformerSimulation;
  mandatory hidden bay_number as Enum_BayName default BAY_1;

  /* Output Datapoint */
  mandatory generic_health_mps as GenericHealth_MPS;
}
