dslversion 1.0.0

namespace com.ge.mpiu
version 1.2.9
displayname "Circuit Breaker Interface - LDDJ"
description "Circuit Breaker Interface"

using com.ge.mpiu.IECDataSetting ; 1.1.0
using com.ge.mpiu.Enum_BayName ; 1.1.0
using com.ge.mpiu.Enum_ElecEtatOnOff ; 1.1.0
using com.ge.mpiu.lddj.AuxiliaryContactCBClosed_SPS ; 1.2.8
using com.ge.mpiu.lddj.AuxiliaryContactCBOpen_SPS ; 1.2.8
using com.ge.mpiu.lddj.BehaviorStatus_MPS ; 1.2.4
using com.ge.mpiu.lddj.BlockingOrderDueLowSF6Pressure_SPS ; 1.2.8
using com.ge.mpiu.lddj.CBBlockClose_SPS ; 1.2.8
using com.ge.mpiu.lddj.CBClose_SPS ; 1.2.8
using com.ge.mpiu.lddj.CBCloseOrder_SPS ; 1.2.8
using com.ge.mpiu.lddj.CBInternalFault_SPS ; 1.2.8
using com.ge.mpiu.lddj.GGIO0 ; 1.2.4
using com.ge.mpiu.lddj.HealthStatus_MPS ; 1.2.4
using com.ge.mpiu.lddj.InputPoleDiscrepancy_SPS ; 1.2.4
using com.ge.mpiu.lddj.InternalThreePhaseTrivialization_SPS ; 1.2.4
using com.ge.mpiu.LPHD0 ; 1.2.4
using com.ge.mpiu.lddj.ManualDJClosing_SPS ; 1.2.4
using com.ge.mpiu.lddj.ManualDJOpening_SPS ; 1.2.4
using com.ge.mpiu.lddj.Mod_MPC ; 1.2.4
using com.ge.mpiu.lddj.ModStatus_MPS ; 1.2.4
using com.ge.mpiu.lddj.PhaseATripOrder_SPS ; 1.2.8
using com.ge.mpiu.lddj.PhaseBTripOrder_SPS ; 1.2.8
using com.ge.mpiu.lddj.PhaseCTripOrder_SPS ; 1.2.8
using com.ge.mpiu.lddj.PoleMismatch_SPS ; 1.2.4
using com.ge.mpiu.lddj.RackedIn_SPS ; 1.2.8
using com.ge.mpiu.lddj.RackedOut_SPS ; 1.2.8
using com.ge.mpiu.lddj.ThreePhaseTripOrder_SPS ; 1.2.8
using com.ge.mpiu.lddj.ThreePhaseTrivOrderARS_SPS ; 1.2.8
using com.ge.mpiu.lddj.TripOrderDueLowSF6Pressure_SPS ; 1.2.8
using com.ge.mpiu.lddj.XCBR0 ; 1.2.4
using com.ge.mpiu.lddj.XCMD0 ; 1.2.4
using com.ge.mpiu.lddj.XSWI0 ; 1.2.4
using com.ge.mpiu.lddj.LDDJInputs ; 1.2.4

entity LDDJ {
  hidden sdbType as string default "LDDJ";
  hidden className as string default "elc.OdElcElectreFct";
  hidden name as string default "Circuit Breaker Interface - LDDJ" <STRLEN 16>;
  hidden xsdTable as string default "lddj";
  hidden vxWorksEngine as bool default true;
  mandatory hidden bay_number as Enum_BayName default BAY_1;
  mandatory hidden param_rev as int32 default 0 <MIN 0, MAX 65535, STEP 10000>;

  // Parameters
  hidden b_lddj_etatinit as Enum_ElecEtatOnOff default ON;
  mandatory t_lddj_tenc as uint32 default 400 <MIN 0, MAX 1000, STEP 5, UNIT "ms"> "ClsDurTmms";
  mandatory t_lddj_tdec as uint32 default 150 <MIN 0, MAX 1000, STEP 5, UNIT "ms"> "OpnDurTmms";
  
  hidden t_lddj_tenc_iec as IECDataSetting;
  hidden t_lddj_tdec_iec as IECDataSetting;

  mandatory hidden NamIr as string default "Rated normal current" <STRLEN 255>;
  mandatory hidden NamIsc as string default "Rated short-circuit breaking current" <STRLEN 255>;
  mandatory hidden NamOpseq as string default "Rated operating sequence" <STRLEN 255>;
  mandatory hidden NamStd as string default "Relevant standard with date of issue" <STRLEN 255>;
  mandatory hidden NamUp as string default "Rated lightning impulse withstand voltage" <STRLEN 255>;
  mandatory hidden NamUr as string default "Rated voltage" <STRLEN 255>;
  mandatory hidden NamYear as string default "Year of manufacture" <STRLEN 255>;

  //Inputs/Outputs
  mandatory hidden xCBR0 as XCBR0;

  //Inputs from T_lddj_input_table (Tgestbd_lddj_input)
  mandatory multiple lddj_inputs as LDDJInputs <MINLENGTH 1, MAXLENGTH 20>;

  // Inputs
  mandatory hidden mod_mpc_norgint as Mod_MPC;
  mandatory multiple norgint_ordre_dec_tri as ThreePhaseTripOrder_SPS <MINLENGTH 32, MAXLENGTH 50>;
  mandatory multiple norgint_ordre_dec_mono_a as PhaseATripOrder_SPS <MINLENGTH 20, MAXLENGTH 20>;
  mandatory multiple norgint_ordre_dec_mono_b as PhaseBTripOrder_SPS <MINLENGTH 20, MAXLENGTH 20>;
  mandatory multiple norgint_ordre_dec_mono_c as PhaseCTripOrder_SPS <MINLENGTH 20, MAXLENGTH 20>;
  mandatory multiple norgint_ordre_encl_tri as CBCloseOrder_SPS <MINLENGTH 20, MAXLENGTH 20>;
  mandatory multiple norgint_ordre_dec_bp_sf6 as TripOrderDueLowSF6Pressure_SPS <MINLENGTH 1, MAXLENGTH 10>;
  mandatory multiple norgint_ordre_bloc_bp_sf6 as BlockingOrderDueLowSF6Pressure_SPS <MINLENGTH 1, MAXLENGTH 10>;
  mandatory multiple norgint_defaut_interne_dj as CBInternalFault_SPS <MINLENGTH 1, MAXLENGTH 10>;
  hidden multiple norgint_discordance_pole as InputPoleDiscrepancy_SPS <MINLENGTH 1, MAXLENGTH 10>; // there is no link with CID
  mandatory multiple norgint_dj_debroche as RackedOut_SPS <MINLENGTH 1, MAXLENGTH 10>;
  mandatory multiple norgint_dj_embroche as RackedIn_SPS <MINLENGTH 1, MAXLENGTH 10>;
  mandatory multiple norgint_crit_enc as CBClose_SPS <MINLENGTH 1, MAXLENGTH 10>;
  mandatory multiple norgint_dj_ouvert as AuxiliaryContactCBOpen_SPS <MINLENGTH 1, MAXLENGTH 10>;
  mandatory multiple norgint_dj_ferme as AuxiliaryContactCBClosed_SPS <MINLENGTH 1, MAXLENGTH 10>;
  mandatory multiple norgint_verr_enclenchement as CBBlockClose_SPS <MINLENGTH 1, MAXLENGTH 10>;
  hidden multiple norgint_ban_tri_ars as ThreePhaseTrivOrderARS_SPS <MINLENGTH 1, MAXLENGTH 10>; // there is no link with CID
  hidden multiple norgint_ban_tri as InternalThreePhaseTrivialization_SPS <MINLENGTH 1, MAXLENGTH 10>; // there is no link with CID
  hidden multiple norgint_ouverture_manuelle as ManualDJOpening_SPS <MINLENGTH 1, MAXLENGTH 10>; // there is no link with CID
  hidden multiple norgint_fermeture_manuelle as ManualDJClosing_SPS <MINLENGTH 1, MAXLENGTH 10>; // there is no link with CID

  //Outputs
  mandatory mod_mps_norgint as ModStatus_MPS;
  mandatory hidden beh_mps_norgint as BehaviorStatus_MPS;
  mandatory hidden health_mps_norgint as HealthStatus_MPS;
  mandatory hidden lphd0 as LPHD0;
  mandatory hidden xCMD0 as XCMD0;
  mandatory hidden xSWI0 as XSWI0;
  mandatory hidden gGIO0 as GGIO0;
  hidden norgint_disc_pole as PoleMismatch_SPS; // there is no link with CID
}
