dslversion 1.0.0

namespace com.ge.mpiu
version 1.2.8
displayname "Disconnector Interface - LDSxy"
description ""

using com.ge.mpiu.Enum_BayName ; 1.1.0
using com.ge.mpiu.Enum_ElecEtatOnOff ; 1.1.0
using com.ge.mpiu.ldsxy.BehaviorStatus_MPS ; 1.2.4
using com.ge.mpiu.ldsxy.BlockedSwitchIndication_SPS ; 1.2.9
using com.ge.mpiu.ldsxy.CloseSwitchAuxContact_SPS ; 1.2.9
using com.ge.mpiu.ldsxy.CloseSwitchOrder_SPS ; 1.2.9
using com.ge.mpiu.ldsxy.EmergencyClosingCommand_SPS ; 1.2.4
using com.ge.mpiu.ldsxy.EmergencyOpeningCommand_SPS ; 1.2.4
using com.ge.mpiu.ldsxy.HealthStatus_MPS ; 1.2.4
using com.ge.mpiu.ldsxy.ModStatus_MPS ; 1.2.4
using com.ge.mpiu.ldsxy.Mod_MPC ; 1.2.4
using com.ge.mpiu.ldsxy.OpenSwitchAuxContact_SPS ; 1.2.9
using com.ge.mpiu.ldsxy.OpenSwitchOrder_SPS ; 1.2.9
using com.ge.mpiu.ldsxy.SwitchLockingCommand_SPS ; 1.2.4
using com.ge.mpiu.ldsxy.SwitchUnlockingCommand_SPS ; 1.2.4
using com.ge.mpiu.ldsxy.UnblockedSwitchIndication_SPS ; 1.2.9
using com.ge.mpiu.ldsxy.GAPC0 ; 1.2.5
using com.ge.mpiu.ldsxy.XCMD1 ; 1.2.4
using com.ge.mpiu.ldsxy.XCMD2 ; 1.2.4
using com.ge.mpiu.ldsxy.XSWI1 ; 1.2.5
using com.ge.mpiu.ldsxy.XSWI2 ; 1.2.5
using com.ge.mpiu.LPHD0 ; 1.2.4

entity LDSxy {
  hidden sdbType as string default "LDSxy";
  hidden className as string default "elc.OdElcElectreFct";
  hidden name as string default "Switch Control - LDSxy" <STRLEN 16>;
  hidden xsdTable as string default "ldsxy";
  hidden vxWorksEngine as bool default true;
  mandatory hidden bay_number as Enum_BayName default BAY_1;
  mandatory hidden param_rev as int32 default 0 <MIN 0, MAX 65535, STEP 10000>;

  // Parameters
  hidden b_ldsxy_etatinit as Enum_ElecEtatOnOff default ON;

  // Input and Output
  mandatory gAPC0 as GAPC0;

  // Inputs
  mandatory hidden mod_mpc_norgint as Mod_MPC;
  mandatory multiple norgint_sxy_condamne as BlockedSwitchIndication_SPS <MINLENGTH 1, MAXLENGTH 10>;
  mandatory multiple norgint_sxy_decondamne as UnblockedSwitchIndication_SPS <MINLENGTH 1, MAXLENGTH 10>;
  mandatory multiple norgint_sxy_ferme as CloseSwitchAuxContact_SPS <MINLENGTH 1, MAXLENGTH 10>;
  mandatory multiple norgint_sxy_ouvert as OpenSwitchAuxContact_SPS <MINLENGTH 1, MAXLENGTH 10>;
  mandatory multiple norgint_ordre_fermeture_sxy as CloseSwitchOrder_SPS <MINLENGTH 1, MAXLENGTH 10>;
  mandatory multiple norgint_ordre_ouverture_sxy as OpenSwitchOrder_SPS <MINLENGTH 1, MAXLENGTH 10>;

  // Internals
  hidden multiple norgint_ouverture_sxy_secours as EmergencyOpeningCommand_SPS <MINLENGTH 1, MAXLENGTH 10>;
  hidden multiple norgint_fermeture_sxy_secours as EmergencyClosingCommand_SPS <MINLENGTH 1, MAXLENGTH 10>;
  hidden multiple norgint_cde_condamnation_sxy as SwitchLockingCommand_SPS <MINLENGTH 1, MAXLENGTH 10>;
  hidden multiple norgint_cde_decondamnation_sxy as SwitchUnlockingCommand_SPS <MINLENGTH 1, MAXLENGTH 10>;

  // Outputs
  mandatory mod_mps_norgint as ModStatus_MPS;
  mandatory hidden beh_mps_norgint as BehaviorStatus_MPS;
  mandatory hidden health_mps_norgint as HealthStatus_MPS;
  mandatory hidden xCMD1 as XCMD1;
  mandatory hidden xCMD2 as XCMD2;
  mandatory xSWI1 as XSWI1;
  mandatory xSWI2 as XSWI2;
  mandatory hidden lphd0 as LPHD0;
}
