dslversion 1.0.0

namespace com.ge.mpiu
version 1.2.4
displayname "Markup Function - LDBALIS"
description "This Logical Device allows the operator to identify the IED on which to intervene."

using com.ge.mpiu.Enum_BayName ; 1.1.0
using com.ge.mpiu.ldbalis.BehaviorStatus_MPS ; 1.2.4
using com.ge.mpiu.ldbalis.BalisInOut ; 1.2.4
using com.ge.mpiu.ldbalis.GAPC0 ; 1.2.4
using com.ge.mpiu.ldbalis.HealthStatus_MPS ; 1.2.4
using com.ge.mpiu.ldbalis.LPHD0 ; 1.2.4
using com.ge.mpiu.ldbalis.Mod_MPC ; 1.2.4
using com.ge.mpiu.ldbalis.ModStatus_MPS ; 1.2.4

entity LDBALIS {
  /* Attributes */
  hidden name as string default "LDBALIS" <STRLEN 16>;
  hidden xsdTable as string default "Tgestbd_obj_balis";
  hidden vxWorksEngine as bool default true;
  mandatory hidden bay_number as Enum_BayName default BAY_1;
  mandatory param_rev as int32 default 0 <MIN 0, MAX 65535, STEP 10000>;

  /* Input Datapoints */
  mandatory mod_mpc_norgint as Mod_MPC;

  /* Output Datapoints */
  mandatory gapc0 as GAPC0;
  mandatory lphd0 as LPHD0;
  mandatory mod_mps_norgint as ModStatus_MPS;
  mandatory beh_mps_norgint as BehaviorStatus_MPS;
  mandatory health_mps_norgint as HealthStatus_MPS;

  /* Sub-entities */
  mandatory multiple balis_in_out as BalisInOut <LENGTH 44>
  
}
