dslversion 1.0.0

namespace com.ge.mpiu
version 1.2.4
displayname "CounterDatapoint"

using com.ge.mpiu.Enum_CounterType ; 1.1.0
using com.ge.mpiu.Enum_EnergyType ; 1.1.0
using com.ge.mpiu.InputDatapoint ; 1.1.1
using com.ge.mpiu.MVElectricalDatapoint ; 1.2.4
using com.ge.mpiu.Enum_ctMeaning ; 1.1.0

entity CounterDatapoint extends InputDatapoint {
   mandatory hidden dataType as string default "COUNTER";
  hidden sdbType as string default "CounterDatapoint";
  mandatory name as string default "Counter datapoint" <STRLEN 0>;
  mandatory readonly ctMeaning as Enum_ctMeaning default VALUE_65535;
  mandatory CounterType as Enum_CounterType default VALUE_0;
  mandatory EnergyType as Enum_EnergyType default VALUE_0;
  mandatory ValidatingPeriodNumber as int32 default 5 <MIN 0, MAX 10000, STEP 1, UNIT "ms">;
  mandatory InvalidityPeriodNumber as int32 default 5 <MIN 5, MAX 10000, STEP 1, UNIT "ms">;
  mandatory ScaleFactor as float default 1.0;
  mandatory ValueAlreadyTotalized as bool default true;
  mandatory CumulPeriod as int32 <MIN 5, MAX 1440, STEP 5, UNIT "mins">;
  mandatory ResetAtCumulativePeriod as bool;
  mandatory PanelAssignment as bool default false;
  hidden ct_default_value as float default 0;
  hidden origin as int32 default 0;

  /* BAP */
  /* the bap default value found in SCD - if set N/A : nothing (65000) otherwise the value. */
  mandatory bap_default_value as uint16 default 0;
}
