dslversion 1.0.0

namespace com.ge.mpiu
version 1.2.4
displayname "DPCDatapoint"

using com.ge.mpiu.OutputDatapoint ; 1.1.1
using com.ge.mpiu.DPCPropertiesForLogic ; 1.1.0
using com.ge.mpiu.DPSDatapoint ; 1.2.4
using com.ge.mpiu.DPSDatapoint_ControlsOnStateChange_DPCDatapoint ; 1.1.0
using com.ge.mpiu.SPSDatapoint ; 1.2.4
using com.ge.mpiu.SPSDatapoint_ControlsOnStateChange_DPCDatapoint ; 1.1.0
using com.ge.mpiu.Enum_xPCActivationMode ; 1.1.1
using com.ge.mpiu.Enum_xPCMeaning ; 1.1.0
using com.ge.mpiu.DPCPrf ; 1.1.0

entity DPCDatapoint extends OutputDatapoint {
  mandatory profile as DPCPrf;
  hidden className as string default "dpt.OdDptDPC";
  mandatory hidden dataType as string default "DPC";
  multiple is_controlled_on_state_change_of as Composite<
    Link<TO, SPSDatapoint, SPSDatapoint_ControlsOnStateChange_DPCDatapoint>,
    Link<TO, DPSDatapoint, DPSDatapoint_ControlsOnStateChange_DPCDatapoint>
  > <MAXLENGTH 20>;
  hidden sdbType as string default "DPCDatapoint";
  mandatory name as string default "DPC datapoint" <STRLEN 0>;
  mandatory readonly xPCMeaning as Enum_xPCMeaning default VALUE_65535;
  mandatory ActivationMode as Enum_xPCActivationMode default VALUE_1;
  mandatory hidden HoldDuration as int32 default 0 <MIN 0, MAX 10000, STEP 10>;
  mandatory CloseDuration as int32 default 500 <MIN 0, MAX 15000, STEP 10, UNIT "ms">;
  mandatory hidden OpenDuration as int32 default 500 <MIN 0, MAX 15000, STEP 10, UNIT "ms">;
  mandatory hidden ConsecutiveOrderDelay as int32 default 0 <MIN 0, MAX 10000, STEP 100, UNIT "ms">;

  /* DPC Properties */
  mandatory hidden propertiesForLogic as DPCPropertiesForLogic;
}