dslversion 1.0.0

namespace com.ge.mpiu
version 1.2.4
displayname "DPS Datapoint"

using com.ge.mpiu.InputDatapoint ; 1.1.1
using com.ge.mpiu.DPSPropertiesForLogic ; 1.1.0
using com.ge.mpiu.DPCDatapoint ; 1.2.4
using com.ge.mpiu.DPSDatapoint_ControlsOnStateChange_DPCDatapoint ; 1.1.0
using com.ge.mpiu.DPSDatapoint_ControlsOnStateChange_SPCDatapoint ; 1.1.0
using com.ge.mpiu.DPSDatapoint_HasForStatusLed_LedChannel ; 1.1.0
using com.ge.mpiu.Enum_DPSForcingManagement ; 1.1.0
using com.ge.mpiu.Enum_DPSStableStateTimeReference ; 1.1.0
using com.ge.mpiu.Enum_DPSStatus ; 1.1.0
using com.ge.mpiu.GroupSPSDatapoint ; 1.2.4
using com.ge.mpiu.GroupSPSDatapoint_ContainsDPS_DPSDatapoint ; 1.1.0
using com.ge.mpiu.LedChannel ; 1.1.0
using com.ge.mpiu.SPCDatapoint ; 1.2.4
using com.ge.mpiu.Enum_xPSDetectMode ; 1.1.1
using com.ge.mpiu.Enum_xPSMeaning ; 1.1.0
using com.ge.mpiu.DPSPrf ; 1.1.0

entity DPSDatapoint extends InputDatapoint {
  mandatory hidden dataType as string default "DPS";
  hidden sdbType as string default "DPSDatapoint";
  mandatory name as string default "DPS datapoint" <STRLEN 0>;
  hidden className as string default "dpt.OdDptDPS";
  mandatory profile as DPSPrf;

  has_state_displayed_on as Link<FROM, LedChannel/is_channel_for, DPSDatapoint_HasForStatusLed_LedChannel>;
  multiple belongs_to_group as Link<TO, GroupSPSDatapoint, GroupSPSDatapoint_ContainsDPS_DPSDatapoint> <MAXLENGTH 100>;
  multiple controls_on_state_change as Composite<
    Link<FROM, SPCDatapoint, DPSDatapoint_ControlsOnStateChange_SPCDatapoint>,
    Link<FROM, DPCDatapoint, DPSDatapoint_ControlsOnStateChange_DPCDatapoint>
  > <MAXLENGTH 65535>;
  mandatory hidden readonly xPSMeaning as Enum_xPSMeaning default VALUE_65535;
  mandatory readonly detect_mode as Enum_xPSDetectMode default PERMANENT;
  mandatory si_init_state as Enum_DPSStatus default VALUE_0;
  mandatory hidden time_motion_00 as int32 default 1 <MIN 0, MAX 600, STEP 1, UNIT "100 ms">;
  mandatory hidden time_motion_11 as int32 default 0 <MIN 0, MAX 600, STEP 1, UNIT "100 ms">;
  mandatory hidden OpenOrResetConfirmationDelay as int32 default 0 <MIN 0, MAX 3000, STEP 1, UNIT "100 ms">;
  mandatory hidden ClosedOrSetConfirmationDelay as int32 default 0 <MIN 0, MAX 3000, STEP 1, UNIT "100 ms">;
  mandatory hidden StableStateTimeReference as Enum_DPSStableStateTimeReference default VALUE_0;
  mandatory hidden TransitionFiltering as bool default false;
  mandatory hidden AcqusitionMirroring as bool default false;
  mandatory hidden QualityBitForcing as bool default true;
  mandatory hidden ForcingManagement as Enum_DPSForcingManagement default NOT_AUTOMATIC;
  hidden origin as int32 default 2;

  /* BAP */
  /* 0: open | 1: close | 65535: if not used | Default value: 0. */
  mandatory bap_default_value as int32 default 0;

  /* DPS Properties */
  mandatory hidden propertiesForLogic as DPSPropertiesForLogic;
}
