dslversion 1.0.0

namespace com.ge.mpiu
version 1.2.4
displayname "MPSDatapoint"

using com.ge.mpiu.InputDatapoint ; 1.1.1
using com.ge.mpiu.MPSPropertiesForLogic ; 1.1.0
using com.ge.mpiu.GroupSPSDatapoint ; 1.2.4
using com.ge.mpiu.GroupSPSDatapoint_ContainsMPS_MPSDatapoint ; 1.1.0
using com.ge.mpiu.MPCDatapoint ; 1.2.4
using com.ge.mpiu.MPSDatapoint_ControlsOnStateChange_MPCDatapoint ; 1.1.0
using com.ge.mpiu.MPSElectricalDatapoint_IsMappedOn_MappingSPSDatapoint ; 1.1.0
using com.ge.mpiu.Enum_MPSForcingManagement ; 1.1.0
using com.ge.mpiu.Enum_MPSMeaning ; 1.1.0
using com.ge.mpiu.MappingSPSDatapoint ; 1.2.4
using com.ge.mpiu.MPSPrf ; 1.1.0

entity MPSDatapoint extends InputDatapoint {
  mandatory hidden dataType as string default "MPS";
  hidden sdbType as string default "MPSDatapoint";
  mandatory name as string default "MPS datapoint" <STRLEN 0>;
  hidden className as string default "dpt.OdDptMPS";
  mandatory hidden profile as MPSPrf;
  
  multiple is_mapped_on as Link<FROM, MappingSPSDatapoint, MPSElectricalDatapoint_IsMappedOn_MappingSPSDatapoint> <MAXLENGTH 16>;
  multiple belongs_to_group as Link<TO, GroupSPSDatapoint, GroupSPSDatapoint_ContainsMPS_MPSDatapoint> <MAXLENGTH 100>;
  multiple controls_on_state_change as Link<FROM, MPCDatapoint, MPSDatapoint_ControlsOnStateChange_MPCDatapoint> <MAXLENGTH 65535>;
  mandatory hidden readonly MPSMeaning as Enum_MPSMeaning default VALUE_65535;
  mandatory sig_init_state as int32 default 0;
  mandatory hidden sig_saved_flag as int8 default 0;
  mandatory hidden FilteringDelay as int32 default 10 <MIN 0, MAX 65535, STEP 1, UNIT "10 ms">;
  mandatory hidden InhibitionDelay as int32 default 10 <MIN 0, MAX 65535, STEP 1, UNIT "10 ms">;
  mandatory hidden ForcingManagement as Enum_MPSForcingManagement default VALUE_0;
  hidden origin as int32 default 2;

  /* BAP */
  /* the bap default value found in SCD - if set N/A : nothing (65000) otherwise the value. */
  mandatory hidden bap_default_value as uint16 default 1;

  /* MPS Properties */
  mandatory hidden propertiesForLogic as MPSPropertiesForLogic;
}
