dslversion 1.0.0

namespace com.ge.mpiu
version 1.2.4
displayname "MVDatapoint"

using com.ge.mpiu.InputDatapoint ; 1.1.1
using com.ge.mpiu.MVPropertiesForLogic ; 1.1.0
using com.ge.mpiu.MVElectricalDatapoint ; 1.2.4
using com.ge.mpiu.Enum_MVScalingMode ; 1.1.0
using com.ge.mpiu.Enum_MVType ; 1.1.0
using com.ge.mpiu.Enum_MVDigitalEncoding ; 1.1.0
using com.ge.mpiu.Enum_TransmissionOnEvent ; 1.1.0
using com.ge.mpiu.Enum_Boolean2 ; 1.1.0
using com.ge.mpiu.MVPrf ; 1.1.0

entity MVDatapoint extends InputDatapoint {
  mandatory hidden dataType as string default "MV";
  hidden sdbType as string default "MVDatapoint";
  mandatory name as string default "MV datapoint" <STRLEN 0>;
  hidden className as string default "dpt.OdDptMV";
  mandatory hidden profile as MVPrf;
  
  mandatory readonly General as string default " ";
  mandatory hidden measurement_type as Enum_MVType default ANALOG;
  mandatory hidden cod_typ as Enum_MVDigitalEncoding default BCD;
  hidden meas_meaning as uint16 default 255;
  mandatory AutomaticForcing as bool default false;
  mandatory AutomaticForcingValue as float default 0.0;
  mandatory TransmissionOnEvent as Enum_TransmissionOnEvent default VALUE_2;
  mandatory Deadband as int32 default 50 <MIN 0, MAX 255, STEP 1>;
  mandatory readonly Ranges as string default " ";
  mandatory MinAcqValue as float default 0.0;
  mandatory MaxAcqValue as float default 0.0;
  mandatory ZeroSub as float default 0.0 <MIN 0.0, MAX 10.0, STEP 0.1>;
  mandatory readonly Thresholds as string default " ";
  mandatory Hysteresis as int32 default 1 <MIN 1, MAX 50, STEP 1>;
  mandatory LLLThresholdUsage as Enum_Boolean2 default FALSE;
  mandatory LLLThreshold as float default 0.0;
  mandatory LLThresholdUsage as Enum_Boolean2 default FALSE;
  mandatory LLThreshold as float default 0.0;
  mandatory LThresholdUsage as Enum_Boolean2 default FALSE;
  mandatory LThreshold as float default 0.0;
  mandatory HThresholdUsage as Enum_Boolean2 default FALSE;
  mandatory HThreshold as float default 0.0;
  mandatory HHThresholdUsage as Enum_Boolean2 default FALSE;
  mandatory HHThreshold as float default 0.0;
  mandatory HHHThresholdUsage as Enum_Boolean2 default FALSE;
  mandatory HHHThreshold as float default 0.0;
  mandatory readonly Scaling as string default " ";
  mandatory ScalingMode as Enum_MVScalingMode default VALUE_0;
  mandatory MinScaledValue as float default 0.0;
  mandatory MaxScaledValue as float default 0.0;
  mandatory A1 as float default 1.0;
  mandatory B1 as float default 0.0;
  mandatory hidden FilteringDelay as int32 default 10 <MIN 0, MAX 65535, STEP 1>;
  mandatory hidden InhibitionDelay as int32 default 10 <MIN 0, MAX 65535, STEP 1>;
  mandatory hidden CurrentValidRange as int32 default 1 <MIN 0, MAX 20, STEP 1>;
  mandatory hidden InhibitDelay as int32 default 10 <MIN 0, MAX 6000, STEP 1>;
  mandatory hidden StabilizationDelay as int32 default 10 <MIN 0, MAX 6000, STEP 1>;
  mandatory hidden StabilizationValue as int32 default 0 <MIN 0, MAX 100, STEP 1>;
  mandatory hidden ValidationDelay as int32 default 50 <MIN 0, MAX 30000, STEP 1>;
  mandatory hidden PanelAssignment as bool default false;
  hidden origin as int32 default 1;

  /* BAP */
  /* the bap default value found in SCD - if set N/A : nothing (65000) otherwise the value. */
  mandatory hidden bap_default_value as float default 0.0;

  /* MV Properties */
  mandatory hidden propertiesForLogic as MVPropertiesForLogic;
}
