dslversion 1.0.0

namespace com.ge.mpiu
version 1.1.0
displayname "Values for Logic"
description "Value used by Logic for each state of DPS datapoint"

using com.ge.mpiu.Enum_ValueForLogic; 1.1.0
using com.ge.mpiu.Enum_ExtendedValueForLogic; 1.1.0

entity DPSPropertiesForLogic {
  hidden xsdTable as string default "Tgestbd_obj_ilock_state_bi";
  hidden name as string default "Values for Logic";

  /* Properties */
  mandatory state0_bi_ilock_state as Enum_ValueForLogic default FALSE;                /* Open state */
  mandatory state1_bi_ilock_state as Enum_ValueForLogic default TRUE;                 /* Close state */
  mandatory motion_bi_ilock_state as Enum_ExtendedValueForLogic default INVALID;      /* Intermediate state */
  mandatory jammed_bi_ilock_state as Enum_ValueForLogic default INVALID;              /* Bad state */
  mandatory undefined_bi_ilock_state as Enum_ValueForLogic default INVALID;           /* Undefined state */
  mandatory faulty_bi_ilock_state as Enum_ValueForLogic default INVALID;              /* Faulty state */
  mandatory unknown_bi_ilock_state as Enum_ValueForLogic default INVALID;             /* Unknown state */
  mandatory forced_state0_bi_ilock_state as Enum_ValueForLogic default FALSE;         /* Forced Open state */         /* Displayed only if EnableFSS = Yes in DPSPrf entity */
  mandatory forced_state1_bi_ilock_state as Enum_ValueForLogic default TRUE;          /* Forced Closed state */       /* Displayed only if EnableFSS = Yes in DPSPrf entity */
  mandatory forced_jammed_bi_ilock_state as Enum_ValueForLogic default INVALID;       /* Forced Bad state */          /* Displayed only if EnableFSS = Yes in DPSPrf entity */
  mandatory suppressed_bi_ilock_state as Enum_ValueForLogic default INVALID;          /* Suppressed state */          /* Displayed only if EnableFSS = Yes in DPSPrf entity */
  mandatory substituted_state0_bi_ilock_state as Enum_ValueForLogic default FALSE;    /* Substituted Open state */    /* Displayed only if EnableFSS = Yes in DPSPrf entity */
  mandatory substituted_state1_bi_ilock_state as Enum_ValueForLogic default TRUE;     /* Substituted Closed state */  /* Displayed only if EnableFSS = Yes in DPSPrf entity */  
  mandatory substituted_jammed_bi_ilock_state as Enum_ValueForLogic default INVALID; /* Substituted Bad state */     /* Displayed only if EnableFSS = Yes in DPSPrf entity */
}