dslversion 1.0.0

namespace com.ge.mpiu
version 1.1.0
displayname "Values for Logic"
description "Value used by Logic for each state of MV datapoint"

using com.ge.mpiu.Enum_ValueForLogic; 1.1.0

entity MVPropertiesForLogic {
  hidden xsdTable as string default "Tgestbd_obj_ilock_state_meas";
  hidden name as string default "Values for Logic";

  /* Properties */
  mandatory valid_meas_ilock_state as Enum_ValueForLogic default TRUE;                      /* Valid state */
  mandatory undefined_meas_ilock_state as Enum_ValueForLogic default INVALID;               /* Undefined state */
  mandatory self_check_fault_state as Enum_ValueForLogic default INVALID;                   /* Faulty state */
  mandatory saturated_meas_ilock_state as Enum_ValueForLogic default INVALID;               /* OverRange state */
  mandatory unknown_meas_ilock_state as Enum_ValueForLogic default INVALID;                 /* Unknown state */
  mandatory open_circuit_meas_ilock_state as Enum_ValueForLogic default INVALID;            /* OpenCircuit state */
  mandatory hidden thres_violation_meas_ilock_state_0 as Enum_ValueForLogic default FALSE;  /* LLL threshold */
  mandatory thres_violation_meas_ilock_state_1 as Enum_ValueForLogic default FALSE;         /* LL threshold */
  mandatory thres_violation_meas_ilock_state_2 as Enum_ValueForLogic default FALSE;         /* L threshold */
  mandatory thres_violation_meas_ilock_state_3 as Enum_ValueForLogic default FALSE;         /* H threshold */
  mandatory thres_violation_meas_ilock_state_4 as Enum_ValueForLogic default FALSE;         /* HH threshold */
  mandatory hidden thres_violation_meas_ilock_state_5 as Enum_ValueForLogic default FALSE;  /* HHH threshold */
  mandatory forced_meas_ilock_state as Enum_ValueForLogic default TRUE;                     /* Forced state */        /* Displayed only if EnableFSS = Yes in MVPrf entity */
  mandatory suppressed_meas_ilock_state as Enum_ValueForLogic default INVALID;              /* Suppressed state */    /* Displayed only if EnableFSS = Yes in MVPrf entity */
  mandatory substituted_meas_ilock_state as Enum_ValueForLogic default TRUE;                /* Substituted state */   /* Displayed only if EnableFSS = Yes in MVPrf entity */
}