dslversion 1.0.0

namespace com.ge.mpiu
version 1.2.4
displayname "SPCDatapoint"

using com.ge.mpiu.OutputDatapoint ; 1.1.1
using com.ge.mpiu.SPCPropertiesForLogic ; 1.1.0
using com.ge.mpiu.DOChannel ; 1.2.4
using com.ge.mpiu.DPSDatapoint ; 1.2.4
using com.ge.mpiu.DPSDatapoint_ControlsOnStateChange_SPCDatapoint ; 1.1.0
using com.ge.mpiu.SPSDatapoint ; 1.2.4
using com.ge.mpiu.SPSDatapoint_ControlsOnStateChange_SPCDatapoint ; 1.1.0
using com.ge.mpiu.Enum_xPCActivationMode ; 1.1.1
using com.ge.mpiu.Enum_xPCMeaning ; 1.1.0
using com.ge.mpiu.SPCPrf ; 1.1.0

entity SPCDatapoint extends OutputDatapoint {
  mandatory hidden dataType as string default "SPC";
  hidden sdbType as string default "SPCDatapoint";
  mandatory name as string default "SPC datapoint" <STRLEN 0>;
  hidden className as string default "dpt.OdDptSPC";
  mandatory hidden profile as SPCPrf;
  
  multiple is_controlled_on_state_change_of as Composite<
    Link<TO, SPSDatapoint, SPSDatapoint_ControlsOnStateChange_SPCDatapoint>,
    Link<TO, DPSDatapoint, DPSDatapoint_ControlsOnStateChange_SPCDatapoint>
  > <MAXLENGTH 20>;
  mandatory hidden readonly xPCMeaning as Enum_xPCMeaning default VALUE_65535;
  mandatory ActivationMode as Enum_xPCActivationMode default VALUE_1;
  mandatory hidden HoldDuration as int32 default 0 <MIN 0, MAX 10000, STEP 10>;
  mandatory CloseDuration as int32 default 500 <MIN 0, MAX 15000, STEP 10, UNIT "ms">;
  mandatory hidden ConsecutiveOrderDelay as int32 default 0 <MIN 0, MAX 10000, STEP 100, UNIT "ms">;

  /* SPC Properties */
  mandatory hidden propertiesForLogic as SPCPropertiesForLogic;
}
