dslversion 1.0.0

namespace com.ge.mpiu
version 1.2.7
displayname "SPSDatapointBAP"

using com.ge.mpiu.InputDatapoint ; 1.1.1
using com.ge.mpiu.SPSPropertiesForLogic ; 1.1.0
using com.ge.mpiu.DPCDatapoint ; 1.2.4
using com.ge.mpiu.GroupSPSDatapoint ; 1.2.4
using com.ge.mpiu.GroupSPSDatapoint_ContainsSPS_SPSDatapoint ; 1.1.0
using com.ge.mpiu.LedChannel ; 1.1.0
using com.ge.mpiu.MappingDPSDatapoint ; 1.2.4
using com.ge.mpiu.MappingSPSDatapoint ; 1.2.4
using com.ge.mpiu.SPCDatapoint ; 1.2.4
using com.ge.mpiu.SPSDatapoint_ControlsOnStateChange_DPCDatapoint ; 1.1.0
using com.ge.mpiu.SPSDatapoint_ControlsOnStateChange_SPCDatapoint ; 1.1.0
using com.ge.mpiu.SPSDatapoint_HasForStatusLed_LedChannel ; 1.1.0
using com.ge.mpiu.SPSElectricalDatapoint_IsMappedOn_MappingDPSDatapoint ; 1.1.0
using com.ge.mpiu.SPSElectricalDatapoint_IsMappedOn_MappingSPSDatapoint ; 1.1.0
using com.ge.mpiu.Enum_SPSForcingManagement ; 1.1.0
using com.ge.mpiu.Enum_SPSStableStateTimeReference ; 1.1.0
using com.ge.mpiu.Enum_SPSStatus ; 1.1.0
using com.ge.mpiu.Enum_xPSDetectMode ; 1.1.1
using com.ge.mpiu.Enum_xPSMeaning ; 1.1.0
using com.ge.mpiu.SPSPrf ; 1.1.0
using com.ge.mpiu.EnumBap ; 1.1.3
using com.ge.mpiu.EnumBap2 ; 1.1.1

entity SPSDatapointBAP extends InputDatapoint {
  mandatory hidden dataType as string default "SPS";
  hidden sdbType as string default "SPSDatapointBAP";
  mandatory name as string default "SPS datapoint" <STRLEN 0>;
  hidden className as string default "dpt.OdDptSPS";
  mandatory profile as SPSPrf;
  
  multiple belongs_to_group as Link<TO, GroupSPSDatapoint, GroupSPSDatapoint_ContainsSPS_SPSDatapoint> <MAXLENGTH 100>;
  has_state_displayed_on as Link<FROM, LedChannel/is_channel_for, SPSDatapoint_HasForStatusLed_LedChannel>;
  multiple controls_on_state_change as Composite<
    Link<FROM, SPCDatapoint, SPSDatapoint_ControlsOnStateChange_SPCDatapoint>,
    Link<FROM, DPCDatapoint, SPSDatapoint_ControlsOnStateChange_DPCDatapoint>
  > <MAXLENGTH 65535>;
  multiple is_mapped_on as Composite<
    Link<FROM, MappingSPSDatapoint, SPSElectricalDatapoint_IsMappedOn_MappingSPSDatapoint>,
    Link<FROM, MappingDPSDatapoint, SPSElectricalDatapoint_IsMappedOn_MappingDPSDatapoint>
  > <MAXLENGTH 10>;

  mandatory hidden readonly xPSMeaning as Enum_xPSMeaning default VALUE_65535;
  mandatory hidden detect_mode as Enum_xPSDetectMode default PERMANENT;
  mandatory si_init_state as Enum_SPSStatus default VALUE_0;
  mandatory hidden OpenOrResetConfirmationDelay as int32 default 0 <MIN 0, MAX 3000, STEP 1, UNIT "100 ms">;
  mandatory hidden ClosedOrSetConfirmationDelay as int32 default 0 <MIN 0, MAX 3000, STEP 1, UNIT "100 ms">;
  mandatory hidden StableStateTimeReference as Enum_SPSStableStateTimeReference default VALUE_0;
  mandatory hidden ForcingManagement as Enum_SPSForcingManagement default VALUE_0;
  hidden origin as int32 default 2;

  /* BAP */
  /* 0: open | 1: close | 65535: if not used | Default value: 0. */
  mandatory bap_default_value as EnumBap2 default OPEN;
  mandatory bap_variant as EnumBap default VALUE_0;

  /* SPS Properties */
  mandatory hidden propertiesForLogic as SPSPropertiesForLogic;
  hidden readonly time_motion_00 as int32 default 100 <MIN 0, MAX 600, STEP 1, UNIT "100 ms">;
  hidden readonly time_motion_11 as int32 default 100 <MIN 0, MAX 600, STEP 1, UNIT "100 ms">;
}
