dslversion 1.0.0

namespace com.ge.mpiu
version 1.2.4
displayname "WaveRecord"
description ""

using com.ge.mpiu.CIChannel ; 1.1.0
using com.ge.mpiu.DPCElectricalDatapoint ; 1.2.4
using com.ge.mpiu.DPSElectricalDatapoint ; 1.2.4
using com.ge.mpiu.MVElectricalDatapoint ; 1.2.4
using com.ge.mpiu.SPCElectricalDatapoint ; 1.2.4
using com.ge.mpiu.SPSElectricalDatapoint ; 1.2.4
using com.ge.mpiu.VIChannel ; 1.1.0
using com.ge.mpiu.WaveRecord_HasForTrigger_DPCElectricalDatapoint ; 1.1.0
using com.ge.mpiu.WaveRecord_HasForTrigger_DPSElectricalDatapoint ; 1.1.0
using com.ge.mpiu.WaveRecord_HasForTrigger_MVElectricalDatapoint ; 1.1.0
using com.ge.mpiu.WaveRecord_HasForTrigger_SPCElectricalDatapoint ; 1.1.0
using com.ge.mpiu.WaveRecord_HasForTrigger_SPSElectricalDatapoint ; 1.1.0
using com.ge.mpiu.WaveRecord_Records_DPSElectricalDatapoint ; 1.1.0
using com.ge.mpiu.WaveRecord_Records_MVElectricalDatapoint ; 1.1.0
using com.ge.mpiu.WaveRecord_Records_SPSElectricalDatapoint ; 1.1.0

entity WaveRecord {
  multiple records_MV as Link<FROM, MVElectricalDatapoint, WaveRecord_Records_MVElectricalDatapoint> <MAXLENGTH 24>;
  multiple records_SPS as Link<FROM, SPSElectricalDatapoint, WaveRecord_Records_SPSElectricalDatapoint> <MAXLENGTH 128>;
  multiple records_DPS as Link<FROM, DPSElectricalDatapoint, WaveRecord_Records_DPSElectricalDatapoint> <MAXLENGTH 128>;
  records_CI as Link<FROM, CIChannel/is_recorded_by>;
  records_VI as Link<FROM, VIChannel/is_recorded_by>;
  multiple has_for_trigger as Composite <
    Link<FROM, SPSElectricalDatapoint, WaveRecord_HasForTrigger_SPSElectricalDatapoint>,
    Link<FROM, DPSElectricalDatapoint, WaveRecord_HasForTrigger_DPSElectricalDatapoint>,
    Link<FROM, SPCElectricalDatapoint, WaveRecord_HasForTrigger_SPCElectricalDatapoint>,
    Link<FROM, DPCElectricalDatapoint, WaveRecord_HasForTrigger_DPCElectricalDatapoint>,
    Link<FROM, MVElectricalDatapoint, WaveRecord_HasForTrigger_MVElectricalDatapoint>
  > <MAXLENGTH 65535>;
  hidden sdbType as string default "WaveRecord";
  mandatory name as string default "Wave recording" <STRLEN 0>;
  mandatory PreTriggerCycle as int32;
  mandatory TotalRecords as int32;
}
