dslversion 1.0.0

namespace com.ge.mpiu
version 1.1.0
displayname "CounterPrf"
description ""

using com.ge.mpiu.Enum_AlarmClearingMode ; 1.1.0
using com.ge.mpiu.Enum_C26xStateTreatment ; 1.1.0
using com.ge.mpiu.DatapointProfile ; 1.1.0
using com.ge.mpiu.Enum_DefaultAlarmGeneration ; 1.1.0
using com.ge.mpiu.Enum_MVPrfSBMCAvailable ; 1.1.0

entity CounterPrf extends DatapointProfile {
  hidden sdbType as string default "CounterPrf";
  hidden className as string default "dpt.OdDptCounterPrf";
  mandatory hidden ShortName as string default "Counter profile" <STRLEN 32>;

  mandatory hidden SBMCAvailable as Enum_MVPrfSBMCAvailable default VALUE_1;

  mandatory EPI as float default 1.0;
  mandatory Unit as string default "" <STRLEN 5>;
  mandatory DescriptionValid as string default "VALID" <STRLEN 16>;
  mandatory DescriptionSelfCheckFault as string default "SELF CHECK FAULT" <STRLEN 16>;
  mandatory DescriptionUnknown as string default "UNKNOWN" <STRLEN 16>;
  mandatory DescriptionForced as string default "FORCED" <STRLEN 16>;
  mandatory DescriptionOverRange as string default "OVER RANGE" <STRLEN 16>;
  mandatory DescriptionUndefined as string default "UNDEFINED" <STRLEN 16>;
  mandatory DescriptionTestMode as string default "TEST" <STRLEN 16>; /* Displayed only if Test = Yes */

  mandatory C26xTreatmentOnEvent as Enum_C26xStateTreatment default VALUE_0;

  /* Out of Scope ICT-V1 */
  mandatory hidden AlarmGeneration as Enum_DefaultAlarmGeneration default VALUE_0;
  mandatory hidden AlmOnValidDefined as bool default false;
  mandatory hidden AlmOnValidDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory hidden AlmOnValidGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory hidden AlmOnValidAudible as bool default false;
  mandatory hidden AlmOnValidClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory hidden AlmOnSelfCheckFaultDefined as bool default false;
  mandatory hidden AlmOnSelfCheckFaultDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory hidden AlmOnSelfCheckFaultGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory hidden AlmOnSelfCheckFaultAudible as bool default false;
  mandatory hidden AlmOnSelfCheckFaultClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory hidden AlmOnUnknownDefined as bool default false;
  mandatory hidden AlmOnUnknownDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory hidden AlmOnUnknownGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory hidden AlmOnUnknownAudible as bool default false;
  mandatory hidden AlmOnUnknownClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory hidden AlmOnForcedDefined as bool default false;
  mandatory hidden AlmOnForcedDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory hidden AlmOnForcedGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory hidden AlmOnForcedAudible as bool default false;
  mandatory hidden AlmOnForcedClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory hidden AlmOnOverRangeDefined as bool default false;
  mandatory hidden AlmOnOverRangeDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory hidden AlmOnOverRangeGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory hidden AlmOnOverRangeAudible as bool default false;
  mandatory hidden AlmOnOverRangeClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory hidden AlmOnUndefinedDefined as bool default false;
  mandatory hidden AlmOnUndefinedDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory hidden AlmOnUndefinedGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory hidden AlmOnUndefinedAudible as bool default false;
  mandatory hidden AlmOnUndefinedClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory hidden AlmOnTestDefined as bool default false;
  mandatory hidden AlmOnTestDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory hidden AlmOnTestGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory hidden AlmOnTestAudible as bool default false;
  mandatory hidden AlmOnTestClearingMode as Enum_AlarmClearingMode default VALUE_2;

  mandatory hidden ReferenceComputation as bool default false;
  /* -- Displayed only if ReferenceComputation = Yes -- */
  mandatory hidden ReferenceHour as int32 default 0 <MIN 0, MAX 23, STEP 1>;
  mandatory hidden ReferenceDay as int32 default 1 <MIN 1, MAX 31, STEP 1>;
  /* -------------------------------------------------- */
}
