dslversion 1.0.0

namespace com.ge.mpiu
version 1.1.0
displayname "DPSPrf"
description ""

using com.ge.mpiu.Enum_AlarmClearingMode ; 1.1.0
using com.ge.mpiu.Enum_C26xStateTreatment ; 1.1.0
using com.ge.mpiu.Enum_DPSPrfSBMCState ; 1.1.0
using com.ge.mpiu.DatapointProfile ; 1.1.0
using com.ge.mpiu.Enum_DefaultAlarmGeneration ; 1.1.0
using com.ge.mpiu.Enum_S2KStateTreatment ; 1.1.0
using com.ge.mpiu.Enum_SBMCAvailable ; 1.1.0

entity DPSPrf extends DatapointProfile {
  hidden sdbType as string default "DPSPrf";
  hidden className as string default "dpt.OdDptDPSPrf";
  mandatory hidden ShortName as string default "DPS profile" <STRLEN 32>;
  mandatory readonly EnableFSS as bool default false;

  /* -- Out of Scope ICT-V1 -- */
  mandatory hidden SBMCAvailable as Enum_SBMCAvailable default VALUE_1;
  mandatory hidden SBMCStateSubstitutionValue as Enum_DPSPrfSBMCState default VALUE_0; /* Displayed only if SBMCAvailable = Yes */
  /* ------------------------- */

  mandatory TogglingFiltering as bool default true; /* Information moved to Channel configuration in ICT, only datapoint wired can have this attribute */
  mandatory hidden MaintBayMode as bool default false;
  mandatory DescriptionOpen as string default "OPEN" <STRLEN 16>;
  mandatory DescriptionClosed as string default "CLOSED" <STRLEN 16>;
  mandatory DescriptionIntermediate as string default "INTERMEDIATE" <STRLEN 16>;
  mandatory DescriptionBadState as string default "BAD STATE" <STRLEN 16>;
  mandatory DescriptionUndefined as string default "UNDEFINED" <STRLEN 16>;
  mandatory DescriptionToggling as string default "TOGGLING" <STRLEN 16>; /* Displayed only if datapoint wired */
  mandatory DescriptionSelfCheckFault as string default "SELF CHECK FAULT" <STRLEN 16>;
  mandatory DescriptionUnknown as string default "UNKNOWN" <STRLEN 16>;
  mandatory DescriptionForced as string default "FORCED" <STRLEN 16>; /* Displayed only if EnableFSS = Yes */
  mandatory DescriptionSuppressed as string default "SUPPRESSED" <STRLEN 16>; /* Displayed only if EnableFSS = Yes */
  mandatory DescriptionSubstitued as string default "SUBSTITUTED" <STRLEN 16>; /* Displayed only if EnableFSS = Yes */
  mandatory DescriptionTestMode as string default "TEST" <STRLEN 16>; /* Displayed only if Test = Yes */

  mandatory C26xTreatmentEvent as Enum_C26xStateTreatment default VALUE_0;

  /* -- Hidden, Out of Scope ICT-V1 -- */
  mandatory AlarmGeneration as Enum_DefaultAlarmGeneration default VALUE_0;
  mandatory AlmOnOpenDefined as bool default false;
  mandatory AlmOnOpenDependentOnDiscordance as bool default false;
  mandatory AlmOnOpenDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory AlmOnOpenGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory AlmOnOpenAudible as bool default false;
  mandatory AlmOnOpenClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory AlmOnClosedDefined as bool default false;
  mandatory AlmOnClosedDependentOnDiscordance as bool default false;
  mandatory AlmOnClosedDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory AlmOnClosedGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory AlmOnClosedAudible as bool default false;
  mandatory AlmOnClosedClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory AlmOnIntermediateDefined as bool default false;
  mandatory AlmOnIntermediateDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory AlmOnIntermediateGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory AlmOnIntermediateAudible as bool default false;
  mandatory AlmOnIntermediateClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory AlmOnBadStateDefined as bool default false;
  mandatory AlmOnBadStateDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory AlmOnBadStateGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory AlmOnBadStateAudible as bool default false;
  mandatory AlmOnBadStateClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory AlmOnUndefinedDefined as bool default false;
  mandatory AlmOnUndefinedDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory AlmOnUndefinedGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory AlmOnUndefinedAudible as bool default false;
  mandatory AlmOnUndefinedClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory AlmOnTogglingDefined as bool default false;
  mandatory AlmOnTogglingDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory AlmOnTogglingGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory AlmOnTogglingAudible as bool default false;
  mandatory AlmOnTogglingClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory AlmOnSelfCheckFaultDefined as bool default false;
  mandatory AlmOnSelfCheckFaultDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory AlmOnSelfCheckFaultGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory AlmOnSelfCheckFaultAudible as bool default false;
  mandatory AlmOnSelfCheckFaultClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory AlmOnUnknownDefined as bool default false;
  mandatory AlmOnUnknownDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory AlmOnUnknownGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory AlmOnUnknownAudible as bool default false;
  mandatory AlmOnUnknownClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory AlmOnForcedDefined as bool default false;
  mandatory AlmOnForcedDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory AlmOnForcedGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory AlmOnForcedAudible as bool default false;
  mandatory AlmOnForcedClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory AlmOnSuppressedDefined as bool default false;
  mandatory AlmOnSuppressedDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory AlmOnSuppressedGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory AlmOnSuppressedAudible as bool default false;
  mandatory AlmOnSuppressedClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory AlmOnSubstituedDefined as bool default false;
  mandatory AlmOnSubstituedDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory AlmOnSubstituedGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory AlmOnSubstituedAudible as bool default false;
  mandatory AlmOnSubstituedClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory AlmOnTestDefined as bool default false;
  mandatory AlmOnTestDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory AlmOnTestGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory AlmOnTestAudible as bool default false;
  mandatory AlmOnTestClearingMode as Enum_AlarmClearingMode default VALUE_2;
}
