dslversion 1.0.0

namespace com.ge.mpiu
version 1.1.0
displayname "MVPrf"
description ""

using com.ge.mpiu.Enum_AlarmClearingMode ; 1.1.0
using com.ge.mpiu.Enum_C26xStateTreatment ; 1.1.0
using com.ge.mpiu.DatapointProfile ; 1.1.0
using com.ge.mpiu.Enum_DefaultAlarmGeneration ; 1.1.0
using com.ge.mpiu.Enum_MVPrfSBMCAvailable ; 1.1.0
using com.ge.mpiu.Enum_S2KStateTreatment ; 1.1.0

entity MVPrf extends DatapointProfile {
  hidden sdbType as string default "MVPrf";
  hidden className as string default "dpt.OdDptMVPrf";
  mandatory hidden ShortName as string default "MV profile" <STRLEN 32>;/* No name required because no profile */
  mandatory readonly EnableFSS as bool default false;

  /* -- SBMC -- */
  mandatory hidden SBMCAvailable as Enum_MVPrfSBMCAvailable default VALUE_1;
  /*----------- */

  mandatory Unit as string default "" <STRLEN 5>;
  mandatory DescriptionValid as string default "VALID" <STRLEN 16>;
  mandatory DescriptionSelfCheckFault as string default "SELF CHECK FAULT" <STRLEN 16>;
  mandatory DescriptionUnknown as string default "UNKNOWN" <STRLEN 16>;
  mandatory hidden DescriptionSuppressed as string default "SUPPRESSED" <STRLEN 16>; /* Displayed only if EnableFSS = Yes */
  mandatory hidden DescriptionForced as string default "FORCED" <STRLEN 16>; /* Displayed only if EnableFSS = Yes */
  mandatory hidden DescriptionSubstitued as string default "SUBSTITUTED" <STRLEN 16>; /* Displayed only if EnableFSS = Yes */
  mandatory DescriptionOverRange as string default "OVER RANGE" <STRLEN 16>;
  mandatory DescriptionUndefined as string default "UNDEFINED" <STRLEN 16>;
  mandatory DescriptionOpenCircuit as string default "OPEN CIRCUIT" <STRLEN 16>;
  mandatory DescriptionLLLThresholdViolation as string default "LLL THRESHOLD" <STRLEN 16>;
  mandatory DescriptionLLThresholdViolation as string default "LL THRESHOLD" <STRLEN 16>;
  mandatory DescriptionLThresholdViolation as string default "L THRESHOLD" <STRLEN 16>;
  mandatory DescriptionHThresholdViolation as string default "H THRESHOLD" <STRLEN 16>;
  mandatory DescriptionHHThresholdViolation as string default "HH THRESHOLD" <STRLEN 16>;
  mandatory DescriptionHHHThresholdViolation as string default "HHH THRESHOLD" <STRLEN 16>;
  mandatory DescriptionTestMode as string default "TEST" <STRLEN 16>;

  mandatory C26xTreatmentOnEvent as Enum_C26xStateTreatment default VALUE_0;

  /* Out of Scope ICT-V1 */
  mandatory hidden AlarmGeneration as Enum_DefaultAlarmGeneration default VALUE_0;
  mandatory hidden AlmOnValidDefined as bool default false;
  mandatory hidden AlmOnValidDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory hidden AlmOnValidGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory hidden AlmOnValidAudible as bool default false;
  mandatory hidden AlmOnValidClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory hidden AlmOnSelfCheckFaultDefined as bool default false;
  mandatory hidden AlmOnSelfCheckFaultDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory hidden AlmOnSelfCheckFaultGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory hidden AlmOnSelfCheckFaultAudible as bool default false;
  mandatory hidden AlmOnSelfCheckFaultClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory hidden AlmOnUnknownDefined as bool default false;
  mandatory hidden AlmOnUnknownDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory hidden AlmOnUnknownGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory hidden AlmOnUnknownAudible as bool default false;
  mandatory hidden AlmOnUnknownClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory hidden AlmOnSuppressedDefined as bool default false;
  mandatory hidden AlmOnSuppressedDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory hidden AlmOnSuppressedGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory hidden AlmOnSuppressedAudible as bool default false;
  mandatory hidden AlmOnSuppressedClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory hidden AlmOnForcedDefined as bool default false;
  mandatory hidden AlmOnForcedDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory hidden AlmOnForcedGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory hidden AlmOnForcedAudible as bool default false;
  mandatory hidden AlmOnForcedClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory hidden AlmOnSubstituedDefined as bool default false;
  mandatory hidden AlmOnSubstituedDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory hidden AlmOnSubstituedGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory hidden AlmOnSubstituedAudible as bool default false;
  mandatory hidden AlmOnSubstituedClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory hidden AlmOnOverRangeDefined as bool default false;
  mandatory hidden AlmOnOverRangeDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory hidden AlmOnOverRangeGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory hidden AlmOnOverRangeAudible as bool default false;
  mandatory hidden AlmOnOverRangeClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory hidden AlmOnUndefinedDefined as bool default false;
  mandatory hidden AlmOnUndefinedDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory hidden AlmOnUndefinedGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory hidden AlmOnUndefinedAudible as bool default false;
  mandatory hidden AlmOnUndefinedClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory hidden AlmOnOpenCircuitDefined as bool default false;
  mandatory hidden AlmOnOpenCircuitDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory hidden AlmOnOpenCircuitGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory hidden AlmOnOpenCircuitAudible as bool default false;
  mandatory hidden AlmOnOpenCircuitClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory hidden AlmOnLLLThresholdViolationDefined as bool default false;
  mandatory hidden AlmOnLLLThresholdViolationDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory hidden AlmOnLLLThresholdViolationGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory hidden AlmOnLLLThresholdViolationAudible as bool default false;
  mandatory hidden AlmOnLLLThresholdViolationClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory hidden AlmOnLLThresholdViolationDefined as bool default false;
  mandatory hidden AlmOnLLThresholdViolationDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory hidden AlmOnLLThresholdViolationGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory hidden AlmOnLLThresholdViolationAudible as bool default false;
  mandatory hidden AlmOnLLThresholdViolationClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory hidden AlmOnLThresholdViolationDefined as bool default false;
  mandatory hidden AlmOnLThresholdViolationDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory hidden AlmOnLThresholdViolationGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory hidden AlmOnLThresholdViolationAudible as bool default false;
  mandatory hidden AlmOnLThresholdViolationClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory hidden AlmOnHThresholdViolationDefined as bool default false;
  mandatory hidden AlmOnHThresholdViolationDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory hidden AlmOnHThresholdViolationGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory hidden AlmOnHThresholdViolationAudible as bool default false;
  mandatory hidden AlmOnHThresholdViolationClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory hidden AlmOnHHThresholdViolationDefined as bool default false;
  mandatory hidden AlmOnHHThresholdViolationDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory hidden AlmOnHHThresholdViolationGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory hidden AlmOnHHThresholdViolationAudible as bool default false;
  mandatory hidden AlmOnHHThresholdViolationClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory hidden AlmOnHHHThresholdViolationDefined as bool default false;
  mandatory hidden AlmOnHHHThresholdViolationDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory hidden AlmOnHHHThresholdViolationGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory hidden AlmOnHHHThresholdViolationAudible as bool default false;
  mandatory hidden AlmOnHHHThresholdViolationClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory hidden AlmOnTestDefined as bool default false;
  mandatory hidden AlmOnTestDelay as int32 default 0 <MIN 0, MAX 300, STEP 1, UNIT "s">;
  mandatory hidden AlmOnTestGravity as int32 default 1 <MIN 1, MAX 5, STEP 1>;
  mandatory hidden AlmOnTestAudible as bool default false;
  mandatory hidden AlmOnTestClearingMode as Enum_AlarmClearingMode default VALUE_2;
  mandatory hidden ReferenceComputation as bool default false;
  mandatory hidden ReferenceHour as int32 default 0 <MIN 0, MAX 23, STEP 1>; /* Displayed only if ReferenceComputation = Yes */
  mandatory hidden ReferenceDay as int32 default 1 <MIN 1, MAX 31, STEP 1>; /* Displayed only if ReferenceComputation = Yes */
}
