dslversion 1.0.0

namespace com.ge.mpiu
version 1.2.5
displayname "Global Parameters"
description ""

using com.ge.mpiu.Enum_BoardTypeDIU ; 1.1.0
using com.ge.mpiu.Enum_BoardTypeDOU ; 1.1.0
using com.ge.mpiu.Enum_BoardTypeHBU ; 1.1.0
using com.ge.mpiu.Enum_RackModel ; 1.1.0
using com.ge.mpiu.Enum_DOUFailure ; 1.1.0
using com.ge.mpiu.GlobalDIUStatus ; 1.2.4
using com.ge.mpiu.GlobalDOUStatus ; 1.2.4
using com.ge.mpiu.GlobalTMUStatus ; 1.2.4
using com.ge.mpiu.GlobalAIUStatus ; 1.2.4

entity GlobalParameters {
  hidden className as string default "scs.GenericContainer";

  /* Data points */
  mandatory hidden globalDIUStatus as GlobalDIUStatus;
  mandatory hidden globalDOUStatus as GlobalDOUStatus;
  mandatory hidden globalTMUStatus as GlobalTMUStatus;

  /* Attributes */
  mandatory hidden RackModel as Enum_RackModel default VALUE_1;

  /* Boards definition */
  mandatory hidden readonly DiuBoardType as Enum_BoardTypeDIU default DIU_JUMPER_ADDRESS;
  mandatory hidden readonly DouBoardType as Enum_BoardTypeDOU default DOU_JUMPER_ADDRESS;
  mandatory hidden readonly HbuBoardType as Enum_BoardTypeHBU default HBU_JUMPER_ADDRESS;

  /* BI parameters */
  mandatory readonly BIACQ as string default " ";
  mandatory TogglingDelay as int32 default 15 <MIN 1, MAX 60, STEP 1, UNIT "s"> "Chatter monitoring period in s (ChatterTms)";
  mandatory hidden TogglingEndDelay as int32 default 15 <MIN 1, MAX 60, STEP 1, UNIT "s"> "Chatter monitoring period in s";
  mandatory TogglingTransitionNumber as int32 default 15 <MIN 1, MAX 99, STEP 1> "Number of contact chatters used as chatter criterion (ChatterNb)";
  mandatory xPSDebouncingTime as int32 default 6 <MIN 0, MAX 20, STEP 1, UNIT "ms">;
  mandatory readonly AnalogM as string default " ";
  mandatory AILongScanCycle as int32 default 1000 <MIN 0, MAX 4000, STEP 500, UNIT "ms"> "Long measurement Scanning period";
  mandatory AIShortScanCycle as int32 default 100 <MIN 0, MAX 1000, STEP 100, UNIT "ms"> "Short measurement Scanning period";
  mandatory AIShortTransCycle as int32 default 500 <MIN 0, MAX 60000, STEP 100, UNIT "ms">
  mandatory AILongTransCycle as int32 default 5 <MIN 0, MAX 864000, STEP 1, UNIT "ms">

  /* DOU parameters */
  mandatory hidden dou_failure_detection as Enum_DOUFailure default "CONTROL_REFUSED";
}