<?xml version="1.0" encoding="UTF-8"?> <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:math="http://www.w3.org/2005/xpath-functions/math" xmlns:array="http://www.w3.org/2005/xpath-functions/array" xmlns:map="http://www.w3.org/2005/xpath-functions/map" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:err="http://www.w3.org/2005/xqt-errors" xmlns:mml="http://www.w3.org/1998/Math/MathML" exclude-result-prefixes="array fn map math xhtml xs err" version="2.0"> <xsl:output method="html" version="5.0" encoding="UTF-8" indent="yes"/> 

<!-- GLOBAL INFORMATIONS -->
<xsl:variable name="Site" select="//PARAMETRES_RTE/@Site"/>
<xsl:variable name="NiveauTension" select="//PARAMETRES_RTE/@NiveauTension"/>
<xsl:variable name="Tranche" select="//PARAMETRES_RTE/@Tranche"/>
<xsl:variable name="VersionFichier" select="//PARAMETRES_RTE/@VersionFichier"/>
<xsl:variable name="Equipement" select="//EQUIPEMENT[(@Modele=$Modele) and (@Fournisseur=$Fournisseur) and (@IdentifiantICD=$IdentifiantICD and @VersionICD=$VersionICD and @RevisionICD=$RevisionICD) 
					or (@IdentifiantICD=$IdentifiantICD  and not(@VersionICD) and not(@RevisionICD)) or (@IdentifiantICD=$IdentifiantICD  and @VersionICD=$VersionICD and not(@RevisionICD)) or (@IdentifiantICD=$IdentifiantICD  and @RevisionICD=$RevisionICD and not(@VersionICD))]"/>

<!-- DEVICE INFORMATIONS -->
<xsl:param name="Fournisseur" select="'GE Vernova'"/>
<xsl:param name="VersionMaterielle" select="'1.0'"/>
<xsl:param name="VersionLogicielle" select="'MU360-1.0'"/>
<xsl:param name="IdentifiantICD" select="'MU360'"/>
<xsl:param name="Modele" select="'MU360'"/>
<xsl:param name="VersionICD" select="'1'"/>
<xsl:param name="RevisionICD" select="'1'"/>
<xsl:param name="TypeRTE" select="'SCU'"/>

<!-- HTML Main Template -->
<xsl:template match="/" name="initial-template">
    <html>
            <head>
                <script type="text/javascript" src="MathJax/MathJax.js?config=TeX-MML-AM_CHTML">
              </script>
                <title>
                </title>
                <style>
                     /* Title h1            */  h1          { font-size:2rem;    color:#ffffff;  width: 1600px;    margin: 50px auto; text-align:center; vertical-align: middle} 
                     /* Title h2            */  h2          { font-size:1.5rem;  color:#ffffff;  width: 1600px;    margin: 20px auto; text-align:center;}
                     /* Title h3            */  h3          { font-size:1.2rem;  color:#ffffff;  width: 1600px;    margin: 10px auto; }
                     /* Header Table Format */  table th    { font-size:1.1rem;  background-color:#2c404d;    color:#fff;    border: 1px solid #2c404d; }
                     /* Table cells         */  table td    { border: 1px solid  #2c404d; text-align: center;   }
                     /* Warning cells       */  tr.warning  { color:#ffff00;}
                     /* Error Cells         */  tr.error    { color:#ff0000; }
                     /* Table format        */  table       { border-collapse:   collapse;    border: 1px solid #2c404d;    color: #ffffff;    margin: 0 auto;    width: 1600px;    margin: 0px auto; }
                                                body        { background-color:  #000000; /* Le fond de la page sera grise */ }
                                                svg         { margin: 0px 50px 0px 0px;  vertical-align: middle}
                                                .Desc,.Id   { text-align:left; padding-left:2em }
                                                .Parameters { width: 250px; text-align:left; padding-left:2em }
                                                .Value      { width: 250px}
                </style>
            </head>
            <body>
                <!-- -->
                <header>
                    <!-- Titre de la page -->
                    <h1>
                        <svg xmlns="http://www.w3.org/2000/svg" width="100" height="100" viewBox="0 0 43.234 43.233" enable-background="new 0 0 43.234 43.233"><path d="M21.618 43.233c-11.918 0-21.618-9.642-21.618-21.618 0-11.915 9.7-21.615 21.618-21.615 11.914 0 21.616 9.7 21.616 21.615 0 11.976-9.702 21.618-21.616 21.618zm0-42.217c-11.378 0-20.601 9.223-20.601 20.599 0 11.377 9.223 20.599 20.601 20.599 11.376 0 20.597-9.222 20.597-20.599 0-11.316-9.22-20.599-20.597-20.599zm18.318 26.762l-.112 .023-.063-.078c.004-.034 .726-2.165 .72-4.611-.009-2.635-1.079-4.251-2.456-4.251-.838 0-1.436 .6-1.436 1.497 0 1.617 1.976 1.737 1.976 5.27 0 1.438-.299 2.812-.778 4.311-2.216 7.483-9.283 10.956-16.167 10.956-3.175 0-5.43-.652-6.102-.953-.027-.014-.05-.067-.029-.12l.087-.061c.272 .108 2.209 .716 4.605 .716 2.635 0 4.192-1.077 4.192-2.397 0-.835-.659-1.494-1.498-1.494-1.617 0-1.737 2.035-5.209 2.035-1.497 0-2.813-.299-4.372-.778-7.426-2.274-10.965-9.282-10.959-16.228 .003-3.382 .95-6.075 .966-6.102l.107-.018 .063 .078c-.087 .28-.716 2.212-.716 4.606 0 2.635 1.077 4.191 2.454 4.191 .779 0 1.439-.598 1.439-1.437 0-1.617-1.977-1.796-1.977-5.27 0-1.497 .299-2.814 .778-4.371 2.276-7.424 9.282-10.905 16.169-10.958 3.2-.024 6.001 .934 6.106 1.018l.019 .108-.079 .06c-.033-.004-1.854-.766-4.61-.766-2.575-.001-4.191 1.077-4.191 2.455 0 .779 .599 1.438 1.497 1.438 1.617 0 1.737-1.977 5.209-1.977 1.497 0 2.814 .299 4.372 .779 7.485 2.275 10.896 9.342 10.957 16.167 .034 3.497-.952 6.143-.962 6.162zm-10.295-5.143c-2.035 0-3.593 1.498-3.593 3.293 0 1.497 .897 2.693 2.096 2.693 .42 0 .838-.24 .838-.778 0-.777-1.032-.968-.952-2.132 .051-.768 .774-1.281 1.491-1.281 1.438 0 2.11 1.393 2.11 2.829-.061 2.216-1.69 3.758-3.606 3.758-2.517 0-4.131-2.396-4.131-4.97 0-3.833 2.514-5.33 3.831-5.688 .014-.001 3.444 .612 3.337-.9-.047-.664-1.036-.92-1.754-.949-.794-.031-1.594 .255-1.594 .255-.419-.211-.708-.623-.886-1.101 2.455-1.856 4.19-3.652 4.19-5.688 0-1.078-.719-2.037-2.096-2.037-2.455 0-4.312 3.114-4.312 5.928 0 .479 0 .958 .121 1.379-1.558 1.137-2.715 1.843-4.812 3.101 0-.263 .055-.938 .23-1.816 .719-.779 1.705-1.944 1.705-2.842 0-.419-.238-.779-.719-.779-1.197 0-2.096 1.797-2.334 3.054-.54 .659-1.617 1.499-2.516 1.499-.719 0-.957-.66-1.019-.898 2.276-.78 5.091-3.894 5.091-6.708 0-.599-.239-1.916-2.036-1.916-2.695 0-4.971 4.012-4.971 7.125-.958 0-1.317-1.018-1.317-1.795 0-.779 .299-1.558 .299-1.796 0-.241-.12-.54-.479-.54-.899 0-1.438 1.197-1.438 2.575 .061 1.917 1.318 3.114 2.995 3.234 .238 1.138 1.257 2.215 2.514 2.215 .779 0 1.737-.239 2.396-.837-.061 .419-.12 .778-.18 1.137-2.635 1.378-4.551 2.336-6.288 3.892-1.373 1.256-2.152 2.932-2.152 4.25 0 1.796 1.139 3.472 3.474 3.472 2.754 0 4.851-2.216 5.868-5.269 .481-1.437 .672-3.528 .792-5.445 2.754-1.556 4.06-2.458 5.496-3.477 .179 .299 .361 .54 .6 .719-1.258 .659-4.251 2.515-4.251 6.886 0 3.115 2.097 6.586 6.227 6.586 3.414 0 5.749-2.813 5.749-5.507-.002-2.456-1.38-4.731-4.014-4.731zm-16.467 8.382c-.898 .041-1.496-.533-1.496-1.49 0-2.575 3.569-5.032 6.264-6.351-.479 3.594-1.692 7.7-4.768 7.841zm1.976-14.131c0-1.977 1.95-5.733 3.143-5.336 1.407 .469-1.167 4.258-3.143 5.336zm11.318-.899c0-2.455 1.662-4.843 2.57-4.389 1.034 .518-.773 2.832-2.57 4.389z" fill="#ffffff"/></svg>
                      
                        GE : Import des parametres pour R#Space 
                    </h1>
                <h2>Informations sur le projet</h2>
                <!-- -->
                <table>
                    <tr>
                        <th>Name</th>
                        <th>Value</th>
                    </tr>
                </table>
                </header>
                <h2>Informations sur le modele</h2>
                <!-- -->
                <table>
                    <tr>
                        <th>Name</th>
                        <th>Value</th>
                    </tr>
                    <tr>
                        <td>
                            Fournisseur
                        </td>
                        <td>
                            <xsl:value-of select="$Fournisseur"/>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            VersionMaterielle
                        </td>
                        <td>
                            <xsl:value-of select="$VersionMaterielle"/>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            VersionLogicielle
                        </td>
                        <td>
                            <xsl:value-of select="$VersionLogicielle"/>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            IdentifiantICD
                        </td>
                        <td>
                            <xsl:value-of select="$IdentifiantICD"/>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Modele
                        </td>
                        <td>
                            <xsl:value-of select="$Modele"/>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            VersionICD
                        </td>
                        <td>
                            <xsl:value-of select="$VersionICD"/>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            RevisionICD
                        </td>
                        <td>
                            <xsl:value-of select="$RevisionICD"/>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Type
                        </td>
                        <td>
                            <xsl:value-of select="$TypeRTE"/>
                        </td>
                    </tr>
                </table>
                <xsl:apply-templates select="$Equipement"/>
            </body>
    </html>
</xsl:template>

<!-- Template Device -->
    <xsl:template match="EQUIPEMENTS/EQUIPEMENT">

<!-- CUSTOMER DATA -->
<xsl:variable name="Lg" select="//OUVRAGES/OUVRAGE[1]/Parametre[@Nom='Lg']/Valeur[1]"/>
<xsl:variable name="Rd" select="//OUVRAGES/OUVRAGE[1]/Parametre[@Nom='Rd']/Valeur[1]"/>
<xsl:variable name="Xd" select="//OUVRAGES/OUVRAGE[1]/Parametre[@Nom='Xd']/Valeur[1]"/>
<xsl:variable name="Ro" select="//OUVRAGES/OUVRAGE[1]/Parametre[@Nom='Ro']/Valeur[1]"/>
<xsl:variable name="Xo" select="//OUVRAGES/OUVRAGE[1]/Parametre[@Nom='Xo']/Valeur[1]"/>
<xsl:variable name="Phi" select="//OUVRAGES/OUVRAGE[1]/Parametre[@Nom='Phi']/Valeur[1]"/>
<xsl:variable name="IST" select="//OUVRAGES/OUVRAGE[1]/Parametre[@Nom='IST']/Valeur[1]"/>
<xsl:variable name="Rom" select="//OUVRAGES/OUVRAGE[1]/Parametre[@Nom='Rom']/Valeur[1]"/>
<xsl:variable name="Xom" select="//OUVRAGES/OUVRAGE[1]/Parametre[@Nom='Xom']/Valeur[1]"/>
<xsl:variable name="Phiom" select="//OUVRAGES/OUVRAGE[1]/Parametre[@Nom='Phiom']/Valeur[1]"/>
<xsl:variable name="kor" select="//OUVRAGES/OUVRAGE[1]/Parametre[@Nom='kor']/Valeur[1]"/>
<xsl:variable name="ko" select="//OUVRAGES/OUVRAGE[1]/Parametre[@Nom='ko']/Valeur[1]"/>
<xsl:variable name="SinPhi" select="//OUVRAGES/OUVRAGE[1]/Parametre[@Nom='SinPhi']/Valeur[1]"/>
<xsl:variable name="KZd" select="//OUVRAGES/OUVRAGE[1]/Parametre[@Nom='KZd']/Valeur[1]"/>
<xsl:variable name="KZom" select="//OUVRAGES/OUVRAGE[1]/Parametre[@Nom='KZom']/Valeur[1]"/>
<xsl:variable name="LigneMutuelle" select="//OUVRAGES/OUVRAGE[1]/Parametre[@Nom='LigneMutuelle']/Valeur[1]"/>
<xsl:variable name="PctLigneMutuelle" select="//OUVRAGES/OUVRAGE[1]/Parametre[@Nom='PctLigneMutuelle']/Valeur[1]"/>
<xsl:variable name="Piquage" select="//OUVRAGES/OUVRAGE[1]/Parametre[@Nom='Piquage']/Valeur[1]"/>
<xsl:variable name="TypeOuvrage" select="//OUVRAGES/OUVRAGE[1]/Parametre[@Nom='TypeOuvrage']/Valeur[1]"/>
<xsl:variable name="RapportTCProtectionHT" select="//REDUCTEURS_MESURES/REDUCTEUR_MESURES[@Nom='TC_Protection']/Parametre[@Nom='Rapport']/Valeur[@TypeValeur='HT']"/>
<xsl:variable name="RapportTCProtectionBT" select="//REDUCTEURS_MESURES/REDUCTEUR_MESURES[@Nom='TC_Protection']/Parametre[@Nom='Rapport']/Valeur[@TypeValeur='BT']"/>
<xsl:variable name="RapportTTProtectionHT" select="//REDUCTEURS_MESURES/REDUCTEUR_MESURES[@Nom='TT_Protection']/Parametre[@Nom='Rapport']/Valeur[@TypeValeur='HT']"/>
<xsl:variable name="RapportTTProtectionBT" select="//REDUCTEURS_MESURES/REDUCTEUR_MESURES[@Nom='TT_Protection']/Parametre[@Nom='Rapport']/Valeur[@TypeValeur='BT']"/>
<xsl:variable name="ANG-Z1-LINE" select="//FONCTIONS/FONCTION[@Nom='PARAM-COMMUNS']/Parametre[@Nom='ANG-Z-LIGNE']/Valeur[1]"/>
<xsl:variable name="ANG-Z2-LINE" select="//FONCTIONS/FONCTION[@Nom='PARAM-COMMUNS']/Parametre[@Nom='ANG-Z-LIGNE']/Valeur[1]"/>
<xsl:variable name="ANG-Z3-LINE" select="//FONCTIONS/FONCTION[@Nom='PARAM-COMMUNS']/Parametre[@Nom='ANG-Z-LIGNE']/Valeur[1]"/>
<xsl:variable name="ANG-Z4-LINE" select="//FONCTIONS/FONCTION[@Nom='PARAM-COMMUNS']/Parametre[@Nom='ANG-Z-LIGNE']/Valeur[1]"/>
<xsl:variable name="T-ENC" select="//FONCTIONS/FONCTION[@LD='LDDJ' and @Equipement=current()/@Nom]/Parametre[@Nom='T-ENC']/Valeur[1]"/>
<xsl:variable name="T-DEC" select="//FONCTIONS/FONCTION[@LD='LDDJ' and @Equipement=current()/@Nom]/Parametre[@Nom='T-DEC']/Valeur[1]"/>

<!-- DEVICE DATA -->
<xsl:variable name="lookup">
        <IedParameter id="t_lddj_tdec" name="t_lddj_tdec" function="LDDJ" desc="LDDJ: Temporisation de maitien des ordres de declenchement" type="Float" defaultValue="150" min='0' max='1000' step='5' valueList="" equationTxt = "T-DEC" deviceImpact = 'false' isProvider = 'false'>
                <xsl:value-of select="$T-DEC"/>
        <inputs>
        <input name='T-DEC'>
        <xsl:attribute name='value' select="$T-DEC"/>
        </input>
        </inputs>
        </IedParameter>/>
        <IedParameter id="t_lddj_tenc" name="t_lddj_tenc" function="LDDJ" desc="LDDJ: Temporisation de maitien des ordres d'enclenchement" type="Float" defaultValue="400" min='0' max='1000' step='5' valueList="" equationTxt = "T-ENC" deviceImpact = 'false' isProvider = 'false'>
                <xsl:value-of select="$T-ENC"/>
        <inputs>
        <input name='T-ENC'>
        <xsl:attribute name='value' select="$T-ENC"/>
        </input>
        </inputs>
        </IedParameter>/>
</xsl:variable>
        <h2><xsl:value-of select="@Nom"/></h2>
        <h3>Parametres mis a jour</h3>
        <table id='param' deviceId='{@Nom}'>
            <!--<caption>Parametres Standards RTE</caption>-->
            <thead>
                <tr>
                    <th>function</th>
                    <th>id</th>
                    <th>description</th>
                    <th>value</th>
                    <th>equation</th>
                    <th>origine</th>
                    <th>reboot</th>
                </tr>
            </thead>
            <tbody>
                <xsl:call-template name="Transformations">
                    <xsl:with-param name="paramTable" select="$lookup"/>
                </xsl:call-template>
                <xsl:call-template name="CustomParameters">
                    <xsl:with-param name="equipement" select="current()"/>
                    <xsl:with-param name="paramTable" select="$lookup"/>
                </xsl:call-template>
            </tbody>
        </table>
        <h3>Parametres Constructeurs disponible</h3>
        <table>
            <thead>
                <tr>
                <th>function</th>
                <th>id</th>
                <th>description</th>
                <th>type</th>
                <th>defaut value</th>
                <th>min</th>
                <th>max</th>
                <th>step</th>
                <th>values list</th>
                </tr>
            </thead>
            <tbody>
                <xsl:call-template name="CustomParametersList"><xsl:with-param name="paramTable" select="$lookup"/></xsl:call-template>
            </tbody>
        </table>
    </xsl:template>


    <xsl:template name="Transformations">
        <xsl:param name="paramTable"/>
        <xsl:for-each select="$paramTable/IedParameter[@isProvider = fn:false()]">
            <xsl:variable name="lvalue">
                <xsl:call-template name="data_validator">
                    <xsl:with-param name="data" select = "current()" />
                    <xsl:with-param name="lCurrentvalue" select = "current()" />
                </xsl:call-template>
            </xsl:variable>
                <xsl:choose>
                    <xsl:when test="fn:contains($lvalue,'Error')">
                <tr>
                <xsl:attribute name="class" select="'error'"/>
                    <td class="Function"><xsl:value-of select="@function"/></td>
                    <td class="Id"><xsl:value-of select="@name"/></td>
                    <td class="Desc"><xsl:value-of select="@desc"/></td>
                    <td class="Value"><xsl:value-of select="$lvalue"/></td>
                    <td class="Equation"><xsl:value-of select="@equationTxt"/></td>
                    <td class="Parameters">
                    <xsl:for-each select="inputs/input">
                        <div class="parameters">
                            <span><xsl:value-of select="@name"/>:</span>
                            <span><xsl:value-of select="@value"/></span>
                        </div>
                    </xsl:for-each>
                    </td>
                    <td class="ImpactFonctionnel"><xsl:value-of select="@deviceImpact"/></td>
                    </tr>
                    </xsl:when>
                    <xsl:when test=" fn:contains($lvalue,'Warning')">
                    </xsl:when>
                    <xsl:otherwise>
                <tr>
                    <td class="Function"><xsl:value-of select="@function"/></td>
                    <td class="Id"><xsl:value-of select="@name"/></td>
                    <td class="Desc"><xsl:value-of select="@desc"/></td>
                    <td class="Value"><xsl:value-of select="$lvalue"/></td>
                    <td class="Equation"><xsl:value-of select="@equationTxt"/></td>
                    <td class="Parameters">
                    <xsl:for-each select="inputs/input">
                        <div class="parameters">
                            <span><xsl:value-of select="@name"/>:</span>
                            <span><xsl:value-of select="@value"/></span>
                        </div>
                    </xsl:for-each>
                    </td>
                    <td class="ImpactFonctionnel"><xsl:value-of select="@deviceImpact"/></td>
                    </tr>
                    </xsl:otherwise>
                </xsl:choose>
        </xsl:for-each>
    </xsl:template>
    <xsl:template name="CustomParameters">
        <xsl:param name="equipement"/>
        <xsl:param name="paramTable"/>
        <xsl:for-each select="$equipement/Parametre">
            <xsl:variable name="setting" select="$paramTable/IedParameter[@id = current()/@Nom and @isProvider = fn:true()]"/>
            <xsl:if test="$setting != ''">
                <tr>
                    <td class="Function"><xsl:value-of select="@function"/></td>
                    <td class="Id"><xsl:value-of select="@Nom"/></td>
                    <td class="Desc"><xsl:value-of select="$setting/@description"/></td>
                        <td class="Value">
                             <xsl:call-template name="data_validator">
                                <xsl:with-param name="data" select = "$setting" />
                                <xsl:with-param name="lCurrentvalue" select = "current()/Valeur" />
                            </xsl:call-template>
                        </td>
                    <td class="Equation"/>
                    <td class="Parameters"><xsl:value-of select="$setting/@equationTxt"/></td>
                    <td class="ImpactFonctionnel"><xsl:value-of select="$setting/@deviceImpact"/></td>
                </tr>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>

    <xsl:template name="CustomParametersList">
        <xsl:param name="paramTable"/>
        <xsl:for-each select="$paramTable/IedParameter[@isProvider = fn:true()]">
            <tr>
                <td><xsl:value-of select="@function"/></td>
                <td><xsl:value-of select="@id"/></td>
                <td><xsl:value-of select="@desc"/></td>
                <td><xsl:value-of select="@type"/></td>
                <td><xsl:value-of select="@defaultValue"/></td>
                <td><xsl:value-of select="@min"/></td>
                <td><xsl:value-of select="@max"/></td>
                <td><xsl:value-of select="@step"/></td>
                <td><xsl:value-of select="@valueList"/></td>
            </tr>
        </xsl:for-each>
    </xsl:template>

    <xsl:template name="data_validator">
            <xsl:param name="data"/>
            <xsl:param name="lCurrentvalue"/>
            <xsl:variable name="ltype" select='$data/@type'/>
            <xsl:variable name="lvalue" select='$data/@defaultValue'/>
            <xsl:choose>
                <xsl:when test="$lCurrentvalue = ''">
                    Warning: la valeur du parametre n'est pas configure, la valeur par defaut sera utilisee: <xsl:value-of select = "$data/@defaultValue"/>                </xsl:when>
                <xsl:when test="fn:contains($lCurrentvalue, 'Error') ">
                    <xsl:value-of select = "$lCurrentvalue"/>
                </xsl:when>
                <xsl:otherwise>
                <xsl:if test="$ltype = 'Integer'">
                    <xsl:variable name="nCurrentvalue" select='xs:integer($lCurrentvalue)'/>
                    <xsl:variable name="lmin" select='xs:integer($data/@min)'/>
                    <xsl:variable name="lmax" select='xs:integer($data/@max)'/>
                    <xsl:variable name="lstep" select='xs:integer($data/@step)'/>
                    <xsl:choose>
                        <xsl:when test=" $lCurrentvalue != '' and  ($lmax = 0 or $nCurrentvalue = $lmax or $nCurrentvalue &lt; $lmax ) and ($lmin = 0 or $nCurrentvalue = $lmin or $nCurrentvalue &gt; $lmin) and ($data/@step = '' or $data/@step = 0 or ( ($nCurrentvalue - $lmin ) mod $lstep ) = 0 )">
                            <xsl:value-of select = "$lCurrentvalue"/>
                        </xsl:when>
                        <xsl:otherwise>
                    Error: la valeur du parametre n'est pas valide                    [<xsl:value-of select = "$lmin"/> &lt; <xsl:value-of select = "$lCurrentvalue"/> &lt; <xsl:value-of select = "$lmax"/> , step: <xsl:value-of select = "$lstep"/> ]                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
                <xsl:if test="$ltype = 'Float'">
                    <xsl:variable name="nCurrentvalue" select='xs:decimal(format-number($lCurrentvalue, "#.00"))'/>
                    <xsl:variable name="lmin" select='xs:decimal($data/@min)'/>
                    <xsl:variable name="lmax" select='xs:decimal($data/@max)'/>
                    <xsl:variable name="lstep" select='xs:decimal($data/@step)'/>
                    <xsl:choose>
                        <xsl:when test=" $lCurrentvalue != '' and  ($lmax = 0 or $nCurrentvalue = $lmax or $nCurrentvalue &lt; $lmax ) and ($lmin = 0 or $nCurrentvalue = $lmin or $nCurrentvalue &gt; $lmin) and ($data/@step = '' or $data/@step = 0 or ( ($nCurrentvalue - $lmin ) mod $lstep ) = 0 )">
                            <xsl:value-of select = "$nCurrentvalue"/>
                        </xsl:when>
                        <xsl:otherwise>
                    Error: la valeur du parametre n'est pas valide                    [<xsl:value-of select = "$lmin"/> &lt; <xsl:value-of select = "$lCurrentvalue"/> &lt; <xsl:value-of select = "$lmax"/> , step: <xsl:value-of select = "$lstep"/> ]                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
                <xsl:if test="$ltype = 'Text'">
                    <xsl:variable name="lmin" select='$data/@min'/>
                    <xsl:variable name="lmax" select='$data/@max'/>
                    <xsl:variable name="size" select="fn:string-length($lCurrentvalue)"/>
                    <xsl:choose>
                        <xsl:when test="  $size != 0 and ($lmax ='' or $size = $lmax or $size &lt; $lmax ) and ($lmin = '' or $size = $lmin or $size &gt; $lmin) ">
                            <xsl:value-of select = "$lCurrentvalue"/>
                        </xsl:when>
                        <xsl:otherwise>
                    Error: la valeur du parametre n'est pas valide                    Taille [<xsl:value-of select = "$lmin"/> &lt; <xsl:value-of select = "$size"/> &lt; <xsl:value-of select = "$lmax"/>]                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
                <xsl:if test="$ltype = 'Enum'">
                    <xsl:variable name="aList" select="tokenize($data/@valueList, ',+')"/>
                    <xsl:variable name="found" select="some $searchString in $aList satisfies normalize-space($searchString) =  fn:string($lCurrentvalue)"/>
                    <xsl:choose>
                        <xsl:when test=" $lCurrentvalue != '' and $found = fn:true()">
                            <xsl:value-of select = "$lCurrentvalue"/>
                        </xsl:when>
                        <xsl:otherwise>
                    Error: la valeur du parametre n'est pas valide                    <xsl:value-of select = "$lCurrentvalue"/> not in [<xsl:value-of select = "$data/@valueList"/>]                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
                <xsl:if test="$ltype = 'Boolean'">
                    <xsl:choose>
                        <xsl:when test="(fn:lower-case($lCurrentvalue) = 'true')  or (fn:lower-case($lCurrentvalue) = 'false') or (fn:lower-case($lCurrentvalue) = '0') or (fn:lower-case($lCurrentvalue) = '1')">
                            <xsl:value-of select = "$lCurrentvalue"/>
                        </xsl:when>
                        <xsl:otherwise>
                    Error: la valeur du parametre n'est pas valide                    [<xsl:value-of select = "$lCurrentvalue"/> not true or false]                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:template>
</xsl:stylesheet>
